package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{BoundedString, PositiveInteger}
import scala.jdk.CollectionConverters._
final case class Disk(
    bytes: Option[PositiveInteger] = None,
    deviceName: Option[BoundedString] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.Disk = {
    import Disk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.Disk
      .builder()
      .optionallyWith(
        bytes.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.bytes)
      .optionallyWith(
        deviceName.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.Disk.ReadOnly =
    zio.aws.mgn.model.Disk.wrap(buildAwsValue())
}
object Disk {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.Disk] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.Disk = zio.aws.mgn.model
      .Disk(bytes.map(value => value), deviceName.map(value => value))
    def bytes: Option[PositiveInteger]
    def deviceName: Option[BoundedString]
    def getBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("bytes", bytes)
    def getDeviceName: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.Disk
  ) extends zio.aws.mgn.model.Disk.ReadOnly {
    override val bytes: Option[PositiveInteger] = scala
      .Option(impl.bytes())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val deviceName: Option[BoundedString] = scala
      .Option(impl.deviceName())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.Disk
  ): zio.aws.mgn.model.Disk.ReadOnly = new Wrapper(impl)
}
