package zio.aws.mgn.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{PaginationToken, StrictlyPositiveInteger}
import scala.jdk.CollectionConverters._
final case class DescribeVcenterClientsRequest(
    maxResults: Option[StrictlyPositiveInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest = {
    import DescribeVcenterClientsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeVcenterClientsRequest.ReadOnly =
    zio.aws.mgn.model.DescribeVcenterClientsRequest.wrap(buildAwsValue())
}
object DescribeVcenterClientsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeVcenterClientsRequest =
      zio.aws.mgn.model.DescribeVcenterClientsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[StrictlyPositiveInteger]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest
  ) extends zio.aws.mgn.model.DescribeVcenterClientsRequest.ReadOnly {
    override val maxResults: Option[StrictlyPositiveInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest
  ): zio.aws.mgn.model.DescribeVcenterClientsRequest.ReadOnly = new Wrapper(
    impl
  )
}
