package zio.aws.mgn.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{PaginationToken, StrictlyPositiveInteger}
import scala.jdk.CollectionConverters._
final case class DescribeSourceServersRequest(
    filters: zio.aws.mgn.model.DescribeSourceServersRequestFilters,
    maxResults: Option[StrictlyPositiveInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest = {
    import DescribeSourceServersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
      .builder()
      .filters(filters.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeSourceServersRequest.ReadOnly =
    zio.aws.mgn.model.DescribeSourceServersRequest.wrap(buildAwsValue())
}
object DescribeSourceServersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeSourceServersRequest =
      zio.aws.mgn.model.DescribeSourceServersRequest(
        filters.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly
    def maxResults: Option[StrictlyPositiveInteger]
    def nextToken: Option[PaginationToken]
    def getFilters: ZIO[
      Any,
      Nothing,
      zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly
    ] = ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
  ) extends zio.aws.mgn.model.DescribeSourceServersRequest.ReadOnly {
    override val filters
        : zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly =
      zio.aws.mgn.model.DescribeSourceServersRequestFilters.wrap(impl.filters())
    override val maxResults: Option[StrictlyPositiveInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest
  ): zio.aws.mgn.model.DescribeSourceServersRequest.ReadOnly = new Wrapper(impl)
}
