package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeJobLogItemsResponse(
    items: Option[Iterable[zio.aws.mgn.model.JobLog]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse = {
    import DescribeJobLogItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly =
    zio.aws.mgn.model.DescribeJobLogItemsResponse.wrap(buildAwsValue())
}
object DescribeJobLogItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeJobLogItemsResponse =
      zio.aws.mgn.model.DescribeJobLogItemsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.mgn.model.JobLog.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getItems: ZIO[Any, AwsError, List[zio.aws.mgn.model.JobLog.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse
  ) extends zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly {
    override val items: Option[List[zio.aws.mgn.model.JobLog.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.JobLog.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse
  ): zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly = new Wrapper(impl)
}
