package zio.aws.mgn.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  PaginationToken,
  StrictlyPositiveInteger,
  JobID
}
import scala.jdk.CollectionConverters._
final case class DescribeJobLogItemsRequest(
    jobID: JobID,
    maxResults: Option[StrictlyPositiveInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest = {
    import DescribeJobLogItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
      .builder()
      .jobID(JobID.unwrap(jobID): java.lang.String)
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeJobLogItemsRequest.ReadOnly =
    zio.aws.mgn.model.DescribeJobLogItemsRequest.wrap(buildAwsValue())
}
object DescribeJobLogItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeJobLogItemsRequest =
      zio.aws.mgn.model.DescribeJobLogItemsRequest(
        jobID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobID: JobID
    def maxResults: Option[StrictlyPositiveInteger]
    def nextToken: Option[PaginationToken]
    def getJobID: ZIO[Any, Nothing, JobID] = ZIO.succeed(jobID)
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
  ) extends zio.aws.mgn.model.DescribeJobLogItemsRequest.ReadOnly {
    override val jobID: JobID = zio.aws.mgn.model.primitives.JobID(impl.jobID())
    override val maxResults: Option[StrictlyPositiveInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest
  ): zio.aws.mgn.model.DescribeJobLogItemsRequest.ReadOnly = new Wrapper(impl)
}
