package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class DataReplicationInitiation(
    nextAttemptDateTime: Option[ISO8601DatetimeString] = None,
    startDateTime: Option[ISO8601DatetimeString] = None,
    steps: Option[Iterable[zio.aws.mgn.model.DataReplicationInitiationStep]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DataReplicationInitiation = {
    import DataReplicationInitiation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DataReplicationInitiation
      .builder()
      .optionallyWith(
        nextAttemptDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.nextAttemptDateTime)
      .optionallyWith(
        startDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.startDateTime)
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DataReplicationInitiation.ReadOnly =
    zio.aws.mgn.model.DataReplicationInitiation.wrap(buildAwsValue())
}
object DataReplicationInitiation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DataReplicationInitiation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DataReplicationInitiation =
      zio.aws.mgn.model.DataReplicationInitiation(
        nextAttemptDateTime.map(value => value),
        startDateTime.map(value => value),
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextAttemptDateTime: Option[ISO8601DatetimeString]
    def startDateTime: Option[ISO8601DatetimeString]
    def steps
        : Option[List[zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly]]
    def getNextAttemptDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("nextAttemptDateTime", nextAttemptDateTime)
    def getStartDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getSteps: ZIO[Any, AwsError, List[
      zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly
    ]] = AwsError.unwrapOptionField("steps", steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInitiation
  ) extends zio.aws.mgn.model.DataReplicationInitiation.ReadOnly {
    override val nextAttemptDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.nextAttemptDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val startDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.startDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val steps: Option[
      List[zio.aws.mgn.model.DataReplicationInitiationStep.ReadOnly]
    ] = scala
      .Option(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.DataReplicationInitiationStep.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInitiation
  ): zio.aws.mgn.model.DataReplicationInitiation.ReadOnly = new Wrapper(impl)
}
