package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  SubnetID,
  SecurityGroupID,
  PositiveInteger,
  TagValue,
  ReplicationConfigurationTemplateID,
  EC2InstanceType,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class UpdateReplicationConfigurationTemplateRequest(
    arn: Option[ARN] = None,
    associateDefaultSecurityGroup: Option[Boolean] = None,
    bandwidthThrottling: Option[PositiveInteger] = None,
    createPublicIP: Option[Boolean] = None,
    dataPlaneRouting: Option[
      zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting
    ] = None,
    defaultLargeStagingDiskType: Option[
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ] = None,
    ebsEncryption: Option[
      zio.aws.mgn.model.ReplicationConfigurationEbsEncryption
    ] = None,
    ebsEncryptionKeyArn: Option[ARN] = None,
    replicationConfigurationTemplateID: ReplicationConfigurationTemplateID,
    replicationServerInstanceType: Option[EC2InstanceType] = None,
    replicationServersSecurityGroupsIDs: Option[Iterable[SecurityGroupID]] =
      None,
    stagingAreaSubnetId: Option[SubnetID] = None,
    stagingAreaTags: Option[Map[TagKey, TagValue]] = None,
    useDedicatedReplicationServer: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest = {
    import UpdateReplicationConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        associateDefaultSecurityGroup.map(value => value: java.lang.Boolean)
      )(_.associateDefaultSecurityGroup)
      .optionallyWith(
        bandwidthThrottling.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.bandwidthThrottling)
      .optionallyWith(createPublicIP.map(value => value: java.lang.Boolean))(
        _.createPublicIP
      )
      .optionallyWith(dataPlaneRouting.map(value => value.unwrap))(
        _.dataPlaneRouting
      )
      .optionallyWith(defaultLargeStagingDiskType.map(value => value.unwrap))(
        _.defaultLargeStagingDiskType
      )
      .optionallyWith(ebsEncryption.map(value => value.unwrap))(_.ebsEncryption)
      .optionallyWith(
        ebsEncryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.ebsEncryptionKeyArn)
      .replicationConfigurationTemplateID(
        ReplicationConfigurationTemplateID.unwrap(
          replicationConfigurationTemplateID
        ): java.lang.String
      )
      .optionallyWith(
        replicationServerInstanceType.map(value =>
          EC2InstanceType.unwrap(value): java.lang.String
        )
      )(_.replicationServerInstanceType)
      .optionallyWith(
        replicationServersSecurityGroupsIDs.map(value =>
          value.map { item =>
            SecurityGroupID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replicationServersSecurityGroupsIDs)
      .optionallyWith(
        stagingAreaSubnetId.map(value =>
          SubnetID.unwrap(value): java.lang.String
        )
      )(_.stagingAreaSubnetId)
      .optionallyWith(
        stagingAreaTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stagingAreaTags)
      .optionallyWith(
        useDedicatedReplicationServer.map(value => value: java.lang.Boolean)
      )(_.useDedicatedReplicationServer)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest.ReadOnly =
    zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateReplicationConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest =
      zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest(
        arn.map(value => value),
        associateDefaultSecurityGroup.map(value => value),
        bandwidthThrottling.map(value => value),
        createPublicIP.map(value => value),
        dataPlaneRouting.map(value => value),
        defaultLargeStagingDiskType.map(value => value),
        ebsEncryption.map(value => value),
        ebsEncryptionKeyArn.map(value => value),
        replicationConfigurationTemplateID,
        replicationServerInstanceType.map(value => value),
        replicationServersSecurityGroupsIDs.map(value => value),
        stagingAreaSubnetId.map(value => value),
        stagingAreaTags.map(value => value),
        useDedicatedReplicationServer.map(value => value)
      )
    def arn: Option[ARN]
    def associateDefaultSecurityGroup: Option[Boolean]
    def bandwidthThrottling: Option[PositiveInteger]
    def createPublicIP: Option[Boolean]
    def dataPlaneRouting
        : Option[zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting]
    def defaultLargeStagingDiskType: Option[
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ]
    def ebsEncryption
        : Option[zio.aws.mgn.model.ReplicationConfigurationEbsEncryption]
    def ebsEncryptionKeyArn: Option[ARN]
    def replicationConfigurationTemplateID: ReplicationConfigurationTemplateID
    def replicationServerInstanceType: Option[EC2InstanceType]
    def replicationServersSecurityGroupsIDs: Option[List[SecurityGroupID]]
    def stagingAreaSubnetId: Option[SubnetID]
    def stagingAreaTags: Option[Map[TagKey, TagValue]]
    def useDedicatedReplicationServer: Option[Boolean]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getAssociateDefaultSecurityGroup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "associateDefaultSecurityGroup",
        associateDefaultSecurityGroup
      )
    def getBandwidthThrottling: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("bandwidthThrottling", bandwidthThrottling)
    def getCreatePublicIP: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("createPublicIP", createPublicIP)
    def getDataPlaneRouting: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting
    ] = AwsError.unwrapOptionField("dataPlaneRouting", dataPlaneRouting)
    def getDefaultLargeStagingDiskType: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ] = AwsError.unwrapOptionField(
      "defaultLargeStagingDiskType",
      defaultLargeStagingDiskType
    )
    def getEbsEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationEbsEncryption
    ] = AwsError.unwrapOptionField("ebsEncryption", ebsEncryption)
    def getEbsEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("ebsEncryptionKeyArn", ebsEncryptionKeyArn)
    def getReplicationConfigurationTemplateID
        : ZIO[Any, Nothing, ReplicationConfigurationTemplateID] =
      ZIO.succeed(replicationConfigurationTemplateID)
    def getReplicationServerInstanceType: ZIO[Any, AwsError, EC2InstanceType] =
      AwsError.unwrapOptionField(
        "replicationServerInstanceType",
        replicationServerInstanceType
      )
    def getReplicationServersSecurityGroupsIDs
        : ZIO[Any, AwsError, List[SecurityGroupID]] =
      AwsError.unwrapOptionField(
        "replicationServersSecurityGroupsIDs",
        replicationServersSecurityGroupsIDs
      )
    def getStagingAreaSubnetId: ZIO[Any, AwsError, SubnetID] =
      AwsError.unwrapOptionField("stagingAreaSubnetId", stagingAreaSubnetId)
    def getStagingAreaTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("stagingAreaTags", stagingAreaTags)
    def getUseDedicatedReplicationServer: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useDedicatedReplicationServer",
        useDedicatedReplicationServer
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest
  ) extends zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest.ReadOnly {
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val associateDefaultSecurityGroup: Option[Boolean] = scala
      .Option(impl.associateDefaultSecurityGroup())
      .map(value => value: Boolean)
    override val bandwidthThrottling: Option[PositiveInteger] = scala
      .Option(impl.bandwidthThrottling())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val createPublicIP: Option[Boolean] =
      scala.Option(impl.createPublicIP()).map(value => value: Boolean)
    override val dataPlaneRouting
        : Option[zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting] =
      scala
        .Option(impl.dataPlaneRouting())
        .map(value =>
          zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting.wrap(value)
        )
    override val defaultLargeStagingDiskType: Option[
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ] = scala
      .Option(impl.defaultLargeStagingDiskType())
      .map(value =>
        zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
          .wrap(value)
      )
    override val ebsEncryption
        : Option[zio.aws.mgn.model.ReplicationConfigurationEbsEncryption] =
      scala
        .Option(impl.ebsEncryption())
        .map(value =>
          zio.aws.mgn.model.ReplicationConfigurationEbsEncryption.wrap(value)
        )
    override val ebsEncryptionKeyArn: Option[ARN] = scala
      .Option(impl.ebsEncryptionKeyArn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val replicationConfigurationTemplateID
        : ReplicationConfigurationTemplateID =
      zio.aws.mgn.model.primitives.ReplicationConfigurationTemplateID(
        impl.replicationConfigurationTemplateID()
      )
    override val replicationServerInstanceType: Option[EC2InstanceType] = scala
      .Option(impl.replicationServerInstanceType())
      .map(value => zio.aws.mgn.model.primitives.EC2InstanceType(value))
    override val replicationServersSecurityGroupsIDs
        : Option[List[SecurityGroupID]] = scala
      .Option(impl.replicationServersSecurityGroupsIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.SecurityGroupID(item)
        }.toList
      )
    override val stagingAreaSubnetId: Option[SubnetID] = scala
      .Option(impl.stagingAreaSubnetId())
      .map(value => zio.aws.mgn.model.primitives.SubnetID(value))
    override val stagingAreaTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.stagingAreaTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val useDedicatedReplicationServer: Option[Boolean] = scala
      .Option(impl.useDedicatedReplicationServer())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest
  ): zio.aws.mgn.model.UpdateReplicationConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
