package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TerminateTargetInstancesResponse(
    job: Option[zio.aws.mgn.model.Job] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse = {
    import TerminateTargetInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly =
    zio.aws.mgn.model.TerminateTargetInstancesResponse.wrap(buildAwsValue())
}
object TerminateTargetInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.TerminateTargetInstancesResponse =
      zio.aws.mgn.model
        .TerminateTargetInstancesResponse(job.map(value => value.asEditable))
    def job: Option[zio.aws.mgn.model.Job.ReadOnly]
    def getJob: ZIO[Any, AwsError, zio.aws.mgn.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse
  ) extends zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly {
    override val job: Option[zio.aws.mgn.model.Job.ReadOnly] =
      scala.Option(impl.job()).map(value => zio.aws.mgn.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse
  ): zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
