package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{PositiveInteger, BoundedString}
import scala.jdk.CollectionConverters._
final case class ReplicationConfigurationReplicatedDisk(
    deviceName: Option[BoundedString] = None,
    iops: Option[PositiveInteger] = None,
    isBootDisk: Option[Boolean] = None,
    stagingDiskType: Option[
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ] = None,
    throughput: Option[PositiveInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk = {
    import ReplicationConfigurationReplicatedDisk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
      .builder()
      .optionallyWith(
        deviceName.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        iops.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.iops)
      .optionallyWith(isBootDisk.map(value => value: java.lang.Boolean))(
        _.isBootDisk
      )
      .optionallyWith(stagingDiskType.map(value => value.unwrap))(
        _.stagingDiskType
      )
      .optionallyWith(
        throughput.map(value => PositiveInteger.unwrap(value): java.lang.Long)
      )(_.throughput)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly =
    zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk
      .wrap(buildAwsValue())
}
object ReplicationConfigurationReplicatedDisk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk =
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk(
        deviceName.map(value => value),
        iops.map(value => value),
        isBootDisk.map(value => value),
        stagingDiskType.map(value => value),
        throughput.map(value => value)
      )
    def deviceName: Option[BoundedString]
    def iops: Option[PositiveInteger]
    def isBootDisk: Option[Boolean]
    def stagingDiskType: Option[
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ]
    def throughput: Option[PositiveInteger]
    def getDeviceName: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getIops: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("iops", iops)
    def getIsBootDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isBootDisk", isBootDisk)
    def getStagingDiskType: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ] = AwsError.unwrapOptionField("stagingDiskType", stagingDiskType)
    def getThroughput: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
  ) extends zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly {
    override val deviceName: Option[BoundedString] = scala
      .Option(impl.deviceName())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val iops: Option[PositiveInteger] = scala
      .Option(impl.iops())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val isBootDisk: Option[Boolean] =
      scala.Option(impl.isBootDisk()).map(value => value: Boolean)
    override val stagingDiskType: Option[
      zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
    ] = scala
      .Option(impl.stagingDiskType())
      .map(value =>
        zio.aws.mgn.model.ReplicationConfigurationReplicatedDiskStagingDiskType
          .wrap(value)
      )
    override val throughput: Option[PositiveInteger] = scala
      .Option(impl.throughput())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk
  ): zio.aws.mgn.model.ReplicationConfigurationReplicatedDisk.ReadOnly =
    new Wrapper(impl)
}
