package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.BoundedString
import scala.jdk.CollectionConverters._
final case class OS(fullString: Option[BoundedString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.OS = {
    import OS.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.OS
      .builder()
      .optionallyWith(
        fullString.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.fullString)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.OS.ReadOnly =
    zio.aws.mgn.model.OS.wrap(buildAwsValue())
}
object OS {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.OS] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.OS =
      zio.aws.mgn.model.OS(fullString.map(value => value))
    def fullString: Option[BoundedString]
    def getFullString: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("fullString", fullString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.OS
  ) extends zio.aws.mgn.model.OS.ReadOnly {
    override val fullString: Option[BoundedString] = scala
      .Option(impl.fullString())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.OS
  ): zio.aws.mgn.model.OS.ReadOnly = new Wrapper(impl)
}
