package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LifeCycleLastCutover(
    finalized: Option[zio.aws.mgn.model.LifeCycleLastCutoverFinalized] = None,
    initiated: Option[zio.aws.mgn.model.LifeCycleLastCutoverInitiated] = None,
    reverted: Option[zio.aws.mgn.model.LifeCycleLastCutoverReverted] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover = {
    import LifeCycleLastCutover.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
      .builder()
      .optionallyWith(finalized.map(value => value.buildAwsValue()))(
        _.finalized
      )
      .optionallyWith(initiated.map(value => value.buildAwsValue()))(
        _.initiated
      )
      .optionallyWith(reverted.map(value => value.buildAwsValue()))(_.reverted)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly =
    zio.aws.mgn.model.LifeCycleLastCutover.wrap(buildAwsValue())
}
object LifeCycleLastCutover {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycleLastCutover =
      zio.aws.mgn.model.LifeCycleLastCutover(
        finalized.map(value => value.asEditable),
        initiated.map(value => value.asEditable),
        reverted.map(value => value.asEditable)
      )
    def finalized
        : Option[zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly]
    def initiated
        : Option[zio.aws.mgn.model.LifeCycleLastCutoverInitiated.ReadOnly]
    def reverted
        : Option[zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly]
    def getFinalized: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly
    ] = AwsError.unwrapOptionField("finalized", finalized)
    def getInitiated: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastCutoverInitiated.ReadOnly
    ] = AwsError.unwrapOptionField("initiated", initiated)
    def getReverted: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly
    ] = AwsError.unwrapOptionField("reverted", reverted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
  ) extends zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly {
    override val finalized
        : Option[zio.aws.mgn.model.LifeCycleLastCutoverFinalized.ReadOnly] =
      scala
        .Option(impl.finalized())
        .map(value =>
          zio.aws.mgn.model.LifeCycleLastCutoverFinalized.wrap(value)
        )
    override val initiated
        : Option[zio.aws.mgn.model.LifeCycleLastCutoverInitiated.ReadOnly] =
      scala
        .Option(impl.initiated())
        .map(value =>
          zio.aws.mgn.model.LifeCycleLastCutoverInitiated.wrap(value)
        )
    override val reverted
        : Option[zio.aws.mgn.model.LifeCycleLastCutoverReverted.ReadOnly] =
      scala
        .Option(impl.reverted())
        .map(value =>
          zio.aws.mgn.model.LifeCycleLastCutoverReverted.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycleLastCutover
  ): zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly = new Wrapper(impl)
}
