package zio.aws.mgn.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{PaginationToken, StrictlyPositiveInteger}
import scala.jdk.CollectionConverters._
final case class DescribeJobsRequest(
    filters: zio.aws.mgn.model.DescribeJobsRequestFilters,
    maxResults: Option[StrictlyPositiveInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeJobsRequest = {
    import DescribeJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
      .builder()
      .filters(filters.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeJobsRequest.ReadOnly =
    zio.aws.mgn.model.DescribeJobsRequest.wrap(buildAwsValue())
}
object DescribeJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeJobsRequest =
      zio.aws.mgn.model.DescribeJobsRequest(
        filters.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly
    def maxResults: Option[StrictlyPositiveInteger]
    def nextToken: Option[PaginationToken]
    def getFilters: ZIO[
      Any,
      Nothing,
      zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly
    ] = ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
  ) extends zio.aws.mgn.model.DescribeJobsRequest.ReadOnly {
    override val filters
        : zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly =
      zio.aws.mgn.model.DescribeJobsRequestFilters.wrap(impl.filters())
    override val maxResults: Option[StrictlyPositiveInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequest
  ): zio.aws.mgn.model.DescribeJobsRequest.ReadOnly = new Wrapper(impl)
}
