package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{BoundedString, PositiveInteger}
import scala.jdk.CollectionConverters._
final case class DataReplicationInfoReplicatedDisk(
    backloggedStorageBytes: Option[PositiveInteger] = None,
    deviceName: Option[BoundedString] = None,
    replicatedStorageBytes: Option[PositiveInteger] = None,
    rescannedStorageBytes: Option[PositiveInteger] = None,
    totalStorageBytes: Option[PositiveInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk = {
    import DataReplicationInfoReplicatedDisk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
      .builder()
      .optionallyWith(
        backloggedStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.backloggedStorageBytes)
      .optionallyWith(
        deviceName.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        replicatedStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.replicatedStorageBytes)
      .optionallyWith(
        rescannedStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.rescannedStorageBytes)
      .optionallyWith(
        totalStorageBytes.map(value =>
          PositiveInteger.unwrap(value): java.lang.Long
        )
      )(_.totalStorageBytes)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly =
    zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.wrap(buildAwsValue())
}
object DataReplicationInfoReplicatedDisk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DataReplicationInfoReplicatedDisk =
      zio.aws.mgn.model.DataReplicationInfoReplicatedDisk(
        backloggedStorageBytes.map(value => value),
        deviceName.map(value => value),
        replicatedStorageBytes.map(value => value),
        rescannedStorageBytes.map(value => value),
        totalStorageBytes.map(value => value)
      )
    def backloggedStorageBytes: Option[PositiveInteger]
    def deviceName: Option[BoundedString]
    def replicatedStorageBytes: Option[PositiveInteger]
    def rescannedStorageBytes: Option[PositiveInteger]
    def totalStorageBytes: Option[PositiveInteger]
    def getBackloggedStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField(
        "backloggedStorageBytes",
        backloggedStorageBytes
      )
    def getDeviceName: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getReplicatedStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField(
        "replicatedStorageBytes",
        replicatedStorageBytes
      )
    def getRescannedStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("rescannedStorageBytes", rescannedStorageBytes)
    def getTotalStorageBytes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("totalStorageBytes", totalStorageBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
  ) extends zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly {
    override val backloggedStorageBytes: Option[PositiveInteger] = scala
      .Option(impl.backloggedStorageBytes())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val deviceName: Option[BoundedString] = scala
      .Option(impl.deviceName())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val replicatedStorageBytes: Option[PositiveInteger] = scala
      .Option(impl.replicatedStorageBytes())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val rescannedStorageBytes: Option[PositiveInteger] = scala
      .Option(impl.rescannedStorageBytes())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
    override val totalStorageBytes: Option[PositiveInteger] = scala
      .Option(impl.totalStorageBytes())
      .map(value => zio.aws.mgn.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk
  ): zio.aws.mgn.model.DataReplicationInfoReplicatedDisk.ReadOnly = new Wrapper(
    impl
  )
}
