package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class DescribeSourceServersRequestFilters(
    isArchived: Option[Boolean] = None,
    lifeCycleStates: Option[Iterable[zio.aws.mgn.model.LifeCycleState]] = None,
    replicationTypes: Option[Iterable[zio.aws.mgn.model.ReplicationType]] =
      None,
    sourceServerIDs: Option[Iterable[SourceServerID]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters = {
    import DescribeSourceServersRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
      .builder()
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(
        lifeCycleStates.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.lifeCycleStatesWithStrings)
      .optionallyWith(
        replicationTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.replicationTypesWithStrings)
      .optionallyWith(
        sourceServerIDs.map(value =>
          value.map { item =>
            SourceServerID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceServerIDs)
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly =
    zio.aws.mgn.model.DescribeSourceServersRequestFilters.wrap(buildAwsValue())
}
object DescribeSourceServersRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeSourceServersRequestFilters =
      zio.aws.mgn.model.DescribeSourceServersRequestFilters(
        isArchived.map(value => value),
        lifeCycleStates.map(value => value),
        replicationTypes.map(value => value),
        sourceServerIDs.map(value => value)
      )
    def isArchived: Option[Boolean]
    def lifeCycleStates: Option[List[zio.aws.mgn.model.LifeCycleState]]
    def replicationTypes: Option[List[zio.aws.mgn.model.ReplicationType]]
    def sourceServerIDs: Option[List[SourceServerID]]
    def getIsArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLifeCycleStates
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.LifeCycleState]] =
      AwsError.unwrapOptionField("lifeCycleStates", lifeCycleStates)
    def getReplicationTypes
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.ReplicationType]] =
      AwsError.unwrapOptionField("replicationTypes", replicationTypes)
    def getSourceServerIDs: ZIO[Any, AwsError, List[SourceServerID]] =
      AwsError.unwrapOptionField("sourceServerIDs", sourceServerIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
  ) extends zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly {
    override val isArchived: Option[Boolean] =
      scala.Option(impl.isArchived()).map(value => value: Boolean)
    override val lifeCycleStates
        : Option[List[zio.aws.mgn.model.LifeCycleState]] = scala
      .Option(impl.lifeCycleStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.LifeCycleState.wrap(item)
        }.toList
      )
    override val replicationTypes
        : Option[List[zio.aws.mgn.model.ReplicationType]] = scala
      .Option(impl.replicationTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.ReplicationType.wrap(item)
        }.toList
      )
    override val sourceServerIDs: Option[List[SourceServerID]] = scala
      .Option(impl.sourceServerIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.SourceServerID(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFilters
  ): zio.aws.mgn.model.DescribeSourceServersRequestFilters.ReadOnly =
    new Wrapper(impl)
}
