package zio.aws.mgn.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  ReplicationConfigurationTemplateID,
  PaginationToken,
  StrictlyPositiveInteger
}
import scala.jdk.CollectionConverters._
final case class DescribeReplicationConfigurationTemplatesRequest(
    maxResults: Option[StrictlyPositiveInteger] = None,
    nextToken: Option[PaginationToken] = None,
    replicationConfigurationTemplateIDs: Iterable[
      ReplicationConfigurationTemplateID
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest = {
    import DescribeReplicationConfigurationTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => StrictlyPositiveInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .replicationConfigurationTemplateIDs(
        replicationConfigurationTemplateIDs.map { item =>
          ReplicationConfigurationTemplateID.unwrap(item): java.lang.String
        }.asJavaCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest.ReadOnly =
    zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationConfigurationTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest =
      zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        replicationConfigurationTemplateIDs
      )
    def maxResults: Option[StrictlyPositiveInteger]
    def nextToken: Option[PaginationToken]
    def replicationConfigurationTemplateIDs
        : List[ReplicationConfigurationTemplateID]
    def getMaxResults: ZIO[Any, AwsError, StrictlyPositiveInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReplicationConfigurationTemplateIDs
        : ZIO[Any, Nothing, List[ReplicationConfigurationTemplateID]] =
      ZIO.succeed(replicationConfigurationTemplateIDs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ) extends zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest.ReadOnly {
    override val maxResults: Option[StrictlyPositiveInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mgn.model.primitives.StrictlyPositiveInteger(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
    override val replicationConfigurationTemplateIDs
        : List[ReplicationConfigurationTemplateID] = impl
      .replicationConfigurationTemplateIDs()
      .asScala
      .map { item =>
        zio.aws.mgn.model.primitives.ReplicationConfigurationTemplateID(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest
  ): zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
