package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  BoundedString,
  TagValue,
  VcenterClientID,
  ISO8601DatetimeString,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class VcenterClient(
    arn: Option[ARN] = None,
    datacenterName: Option[BoundedString] = None,
    hostname: Option[BoundedString] = None,
    lastSeenDatetime: Option[ISO8601DatetimeString] = None,
    sourceServerTags: Option[Map[TagKey, TagValue]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    vcenterClientID: Option[VcenterClientID] = None,
    vcenterUUID: Option[BoundedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.VcenterClient = {
    import VcenterClient.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.VcenterClient
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        datacenterName.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.datacenterName)
      .optionallyWith(
        hostname.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        lastSeenDatetime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastSeenDatetime)
      .optionallyWith(
        sourceServerTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.sourceServerTags)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        vcenterClientID.map(value =>
          VcenterClientID.unwrap(value): java.lang.String
        )
      )(_.vcenterClientID)
      .optionallyWith(
        vcenterUUID.map(value => BoundedString.unwrap(value): java.lang.String)
      )(_.vcenterUUID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.VcenterClient.ReadOnly =
    zio.aws.mgn.model.VcenterClient.wrap(buildAwsValue())
}
object VcenterClient {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.VcenterClient] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.VcenterClient =
      zio.aws.mgn.model.VcenterClient(
        arn.map(value => value),
        datacenterName.map(value => value),
        hostname.map(value => value),
        lastSeenDatetime.map(value => value),
        sourceServerTags.map(value => value),
        tags.map(value => value),
        vcenterClientID.map(value => value),
        vcenterUUID.map(value => value)
      )
    def arn: Option[ARN]
    def datacenterName: Option[BoundedString]
    def hostname: Option[BoundedString]
    def lastSeenDatetime: Option[ISO8601DatetimeString]
    def sourceServerTags: Option[Map[TagKey, TagValue]]
    def tags: Option[Map[TagKey, TagValue]]
    def vcenterClientID: Option[VcenterClientID]
    def vcenterUUID: Option[BoundedString]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getDatacenterName: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("datacenterName", datacenterName)
    def getHostname: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getLastSeenDatetime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("lastSeenDatetime", lastSeenDatetime)
    def getSourceServerTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("sourceServerTags", sourceServerTags)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVcenterClientID: ZIO[Any, AwsError, VcenterClientID] =
      AwsError.unwrapOptionField("vcenterClientID", vcenterClientID)
    def getVcenterUUID: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("vcenterUUID", vcenterUUID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.VcenterClient
  ) extends zio.aws.mgn.model.VcenterClient.ReadOnly {
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val datacenterName: Option[BoundedString] = scala
      .Option(impl.datacenterName())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val hostname: Option[BoundedString] = scala
      .Option(impl.hostname())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val lastSeenDatetime: Option[ISO8601DatetimeString] = scala
      .Option(impl.lastSeenDatetime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val sourceServerTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.sourceServerTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vcenterClientID: Option[VcenterClientID] = scala
      .Option(impl.vcenterClientID())
      .map(value => zio.aws.mgn.model.primitives.VcenterClientID(value))
    override val vcenterUUID: Option[BoundedString] = scala
      .Option(impl.vcenterUUID())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.VcenterClient
  ): zio.aws.mgn.model.VcenterClient.ReadOnly = new Wrapper(impl)
}
