package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class DeleteSourceServerRequest(sourceServerID: SourceServerID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest = {
    import DeleteSourceServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest
      .builder()
      .sourceServerID(SourceServerID.unwrap(sourceServerID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DeleteSourceServerRequest.ReadOnly =
    zio.aws.mgn.model.DeleteSourceServerRequest.wrap(buildAwsValue())
}
object DeleteSourceServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DeleteSourceServerRequest =
      zio.aws.mgn.model.DeleteSourceServerRequest(sourceServerID)
    def sourceServerID: SourceServerID
    def getSourceServerID: ZIO[Any, Nothing, SourceServerID] =
      ZIO.succeed(sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest
  ) extends zio.aws.mgn.model.DeleteSourceServerRequest.ReadOnly {
    override val sourceServerID: SourceServerID =
      zio.aws.mgn.model.primitives.SourceServerID(impl.sourceServerID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest
  ): zio.aws.mgn.model.DeleteSourceServerRequest.ReadOnly = new Wrapper(impl)
}
