package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.SourceServerID
import scala.jdk.CollectionConverters._
final case class ParticipatingServer(
    launchStatus: Option[zio.aws.mgn.model.LaunchStatus] = None,
    sourceServerID: Option[SourceServerID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.ParticipatingServer = {
    import ParticipatingServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.ParticipatingServer
      .builder()
      .optionallyWith(launchStatus.map(value => value.unwrap))(_.launchStatus)
      .optionallyWith(
        sourceServerID.map(value =>
          SourceServerID.unwrap(value): java.lang.String
        )
      )(_.sourceServerID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.ParticipatingServer.ReadOnly =
    zio.aws.mgn.model.ParticipatingServer.wrap(buildAwsValue())
}
object ParticipatingServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.ParticipatingServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.ParticipatingServer =
      zio.aws.mgn.model.ParticipatingServer(
        launchStatus.map(value => value),
        sourceServerID.map(value => value)
      )
    def launchStatus: Option[zio.aws.mgn.model.LaunchStatus]
    def sourceServerID: Option[SourceServerID]
    def getLaunchStatus: ZIO[Any, AwsError, zio.aws.mgn.model.LaunchStatus] =
      AwsError.unwrapOptionField("launchStatus", launchStatus)
    def getSourceServerID: ZIO[Any, AwsError, SourceServerID] =
      AwsError.unwrapOptionField("sourceServerID", sourceServerID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.ParticipatingServer
  ) extends zio.aws.mgn.model.ParticipatingServer.ReadOnly {
    override val launchStatus: Option[zio.aws.mgn.model.LaunchStatus] = scala
      .Option(impl.launchStatus())
      .map(value => zio.aws.mgn.model.LaunchStatus.wrap(value))
    override val sourceServerID: Option[SourceServerID] = scala
      .Option(impl.sourceServerID())
      .map(value => zio.aws.mgn.model.primitives.SourceServerID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.ParticipatingServer
  ): zio.aws.mgn.model.ParticipatingServer.ReadOnly = new Wrapper(impl)
}
