package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  SourceServerID,
  SmallBoundedString,
  BoundedString
}
import scala.jdk.CollectionConverters._
final case class GetLaunchConfigurationResponse(
    copyPrivateIp: Option[Boolean] = None,
    copyTags: Option[Boolean] = None,
    ec2LaunchTemplateID: Option[BoundedString] = None,
    launchDisposition: Option[zio.aws.mgn.model.LaunchDisposition] = None,
    licensing: Option[zio.aws.mgn.model.Licensing] = None,
    name: Option[SmallBoundedString] = None,
    sourceServerID: Option[SourceServerID] = None,
    targetInstanceTypeRightSizingMethod: Option[
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse = {
    import GetLaunchConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse
      .builder()
      .optionallyWith(copyPrivateIp.map(value => value: java.lang.Boolean))(
        _.copyPrivateIp
      )
      .optionallyWith(copyTags.map(value => value: java.lang.Boolean))(
        _.copyTags
      )
      .optionallyWith(
        ec2LaunchTemplateID.map(value =>
          BoundedString.unwrap(value): java.lang.String
        )
      )(_.ec2LaunchTemplateID)
      .optionallyWith(launchDisposition.map(value => value.unwrap))(
        _.launchDisposition
      )
      .optionallyWith(licensing.map(value => value.buildAwsValue()))(
        _.licensing
      )
      .optionallyWith(
        name.map(value => SmallBoundedString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        sourceServerID.map(value =>
          SourceServerID.unwrap(value): java.lang.String
        )
      )(_.sourceServerID)
      .optionallyWith(
        targetInstanceTypeRightSizingMethod.map(value => value.unwrap)
      )(_.targetInstanceTypeRightSizingMethod)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.GetLaunchConfigurationResponse.ReadOnly =
    zio.aws.mgn.model.GetLaunchConfigurationResponse.wrap(buildAwsValue())
}
object GetLaunchConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.GetLaunchConfigurationResponse =
      zio.aws.mgn.model.GetLaunchConfigurationResponse(
        copyPrivateIp.map(value => value),
        copyTags.map(value => value),
        ec2LaunchTemplateID.map(value => value),
        launchDisposition.map(value => value),
        licensing.map(value => value.asEditable),
        name.map(value => value),
        sourceServerID.map(value => value),
        targetInstanceTypeRightSizingMethod.map(value => value)
      )
    def copyPrivateIp: Option[Boolean]
    def copyTags: Option[Boolean]
    def ec2LaunchTemplateID: Option[BoundedString]
    def launchDisposition: Option[zio.aws.mgn.model.LaunchDisposition]
    def licensing: Option[zio.aws.mgn.model.Licensing.ReadOnly]
    def name: Option[SmallBoundedString]
    def sourceServerID: Option[SourceServerID]
    def targetInstanceTypeRightSizingMethod
        : Option[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod]
    def getCopyPrivateIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyPrivateIp", copyPrivateIp)
    def getCopyTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getEc2LaunchTemplateID: ZIO[Any, AwsError, BoundedString] =
      AwsError.unwrapOptionField("ec2LaunchTemplateID", ec2LaunchTemplateID)
    def getLaunchDisposition
        : ZIO[Any, AwsError, zio.aws.mgn.model.LaunchDisposition] =
      AwsError.unwrapOptionField("launchDisposition", launchDisposition)
    def getLicensing: ZIO[Any, AwsError, zio.aws.mgn.model.Licensing.ReadOnly] =
      AwsError.unwrapOptionField("licensing", licensing)
    def getName: ZIO[Any, AwsError, SmallBoundedString] =
      AwsError.unwrapOptionField("name", name)
    def getSourceServerID: ZIO[Any, AwsError, SourceServerID] =
      AwsError.unwrapOptionField("sourceServerID", sourceServerID)
    def getTargetInstanceTypeRightSizingMethod: ZIO[
      Any,
      AwsError,
      zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod
    ] = AwsError.unwrapOptionField(
      "targetInstanceTypeRightSizingMethod",
      targetInstanceTypeRightSizingMethod
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse
  ) extends zio.aws.mgn.model.GetLaunchConfigurationResponse.ReadOnly {
    override val copyPrivateIp: Option[Boolean] =
      scala.Option(impl.copyPrivateIp()).map(value => value: Boolean)
    override val copyTags: Option[Boolean] =
      scala.Option(impl.copyTags()).map(value => value: Boolean)
    override val ec2LaunchTemplateID: Option[BoundedString] = scala
      .Option(impl.ec2LaunchTemplateID())
      .map(value => zio.aws.mgn.model.primitives.BoundedString(value))
    override val launchDisposition
        : Option[zio.aws.mgn.model.LaunchDisposition] = scala
      .Option(impl.launchDisposition())
      .map(value => zio.aws.mgn.model.LaunchDisposition.wrap(value))
    override val licensing: Option[zio.aws.mgn.model.Licensing.ReadOnly] = scala
      .Option(impl.licensing())
      .map(value => zio.aws.mgn.model.Licensing.wrap(value))
    override val name: Option[SmallBoundedString] = scala
      .Option(impl.name())
      .map(value => zio.aws.mgn.model.primitives.SmallBoundedString(value))
    override val sourceServerID: Option[SourceServerID] = scala
      .Option(impl.sourceServerID())
      .map(value => zio.aws.mgn.model.primitives.SourceServerID(value))
    override val targetInstanceTypeRightSizingMethod
        : Option[zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod] = scala
      .Option(impl.targetInstanceTypeRightSizingMethod())
      .map(value =>
        zio.aws.mgn.model.TargetInstanceTypeRightSizingMethod.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse
  ): zio.aws.mgn.model.GetLaunchConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
