package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.LargeBoundedString
import scala.jdk.CollectionConverters._
final case class DataReplicationError(
    error: Option[zio.aws.mgn.model.DataReplicationErrorString] = None,
    rawError: Option[LargeBoundedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DataReplicationError = {
    import DataReplicationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DataReplicationError
      .builder()
      .optionallyWith(error.map(value => value.unwrap))(_.error)
      .optionallyWith(
        rawError.map(value =>
          LargeBoundedString.unwrap(value): java.lang.String
        )
      )(_.rawError)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DataReplicationError.ReadOnly =
    zio.aws.mgn.model.DataReplicationError.wrap(buildAwsValue())
}
object DataReplicationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DataReplicationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DataReplicationError =
      zio.aws.mgn.model.DataReplicationError(
        error.map(value => value),
        rawError.map(value => value)
      )
    def error: Option[zio.aws.mgn.model.DataReplicationErrorString]
    def rawError: Option[LargeBoundedString]
    def getError
        : ZIO[Any, AwsError, zio.aws.mgn.model.DataReplicationErrorString] =
      AwsError.unwrapOptionField("error", error)
    def getRawError: ZIO[Any, AwsError, LargeBoundedString] =
      AwsError.unwrapOptionField("rawError", rawError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationError
  ) extends zio.aws.mgn.model.DataReplicationError.ReadOnly {
    override val error: Option[zio.aws.mgn.model.DataReplicationErrorString] =
      scala
        .Option(impl.error())
        .map(value => zio.aws.mgn.model.DataReplicationErrorString.wrap(value))
    override val rawError: Option[LargeBoundedString] = scala
      .Option(impl.rawError())
      .map(value => zio.aws.mgn.model.primitives.LargeBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DataReplicationError
  ): zio.aws.mgn.model.DataReplicationError.ReadOnly = new Wrapper(impl)
}
