package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  SourceServerID,
  LargeBoundedString,
  EC2InstanceID
}
import scala.jdk.CollectionConverters._
final case class JobLogEventData(
    conversionServerID: Option[EC2InstanceID] = None,
    rawError: Option[LargeBoundedString] = None,
    sourceServerID: Option[SourceServerID] = None,
    targetInstanceID: Option[EC2InstanceID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.JobLogEventData = {
    import JobLogEventData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.JobLogEventData
      .builder()
      .optionallyWith(
        conversionServerID.map(value =>
          EC2InstanceID.unwrap(value): java.lang.String
        )
      )(_.conversionServerID)
      .optionallyWith(
        rawError.map(value =>
          LargeBoundedString.unwrap(value): java.lang.String
        )
      )(_.rawError)
      .optionallyWith(
        sourceServerID.map(value =>
          SourceServerID.unwrap(value): java.lang.String
        )
      )(_.sourceServerID)
      .optionallyWith(
        targetInstanceID.map(value =>
          EC2InstanceID.unwrap(value): java.lang.String
        )
      )(_.targetInstanceID)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.JobLogEventData.ReadOnly =
    zio.aws.mgn.model.JobLogEventData.wrap(buildAwsValue())
}
object JobLogEventData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.JobLogEventData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.JobLogEventData =
      zio.aws.mgn.model.JobLogEventData(
        conversionServerID.map(value => value),
        rawError.map(value => value),
        sourceServerID.map(value => value),
        targetInstanceID.map(value => value)
      )
    def conversionServerID: Option[EC2InstanceID]
    def rawError: Option[LargeBoundedString]
    def sourceServerID: Option[SourceServerID]
    def targetInstanceID: Option[EC2InstanceID]
    def getConversionServerID: ZIO[Any, AwsError, EC2InstanceID] =
      AwsError.unwrapOptionField("conversionServerID", conversionServerID)
    def getRawError: ZIO[Any, AwsError, LargeBoundedString] =
      AwsError.unwrapOptionField("rawError", rawError)
    def getSourceServerID: ZIO[Any, AwsError, SourceServerID] =
      AwsError.unwrapOptionField("sourceServerID", sourceServerID)
    def getTargetInstanceID: ZIO[Any, AwsError, EC2InstanceID] =
      AwsError.unwrapOptionField("targetInstanceID", targetInstanceID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.JobLogEventData
  ) extends zio.aws.mgn.model.JobLogEventData.ReadOnly {
    override val conversionServerID: Option[EC2InstanceID] = scala
      .Option(impl.conversionServerID())
      .map(value => zio.aws.mgn.model.primitives.EC2InstanceID(value))
    override val rawError: Option[LargeBoundedString] = scala
      .Option(impl.rawError())
      .map(value => zio.aws.mgn.model.primitives.LargeBoundedString(value))
    override val sourceServerID: Option[SourceServerID] = scala
      .Option(impl.sourceServerID())
      .map(value => zio.aws.mgn.model.primitives.SourceServerID(value))
    override val targetInstanceID: Option[EC2InstanceID] = scala
      .Option(impl.targetInstanceID())
      .map(value => zio.aws.mgn.model.primitives.EC2InstanceID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.JobLogEventData
  ): zio.aws.mgn.model.JobLogEventData.ReadOnly = new Wrapper(impl)
}
