package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class DescribeSourceServersResponse(
    items: Option[Iterable[zio.aws.mgn.model.SourceServer]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse = {
    import DescribeSourceServersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly =
    zio.aws.mgn.model.DescribeSourceServersResponse.wrap(buildAwsValue())
}
object DescribeSourceServersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeSourceServersResponse =
      zio.aws.mgn.model.DescribeSourceServersResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.mgn.model.SourceServer.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mgn.model.SourceServer.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
  ) extends zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly {
    override val items: Option[List[zio.aws.mgn.model.SourceServer.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mgn.model.SourceServer.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mgn.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse
  ): zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly = new Wrapper(
    impl
  )
}
