package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{JobID, ISO8601DatetimeString}
import scala.jdk.CollectionConverters._
final case class DescribeJobsRequestFilters(
    fromDate: Option[ISO8601DatetimeString] = None,
    jobIDs: Option[Iterable[JobID]] = None,
    toDate: Option[ISO8601DatetimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters = {
    import DescribeJobsRequestFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
      .builder()
      .optionallyWith(
        fromDate.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.fromDate)
      .optionallyWith(
        jobIDs.map(value =>
          value.map { item =>
            JobID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobIDs)
      .optionallyWith(
        toDate.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.toDate)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly =
    zio.aws.mgn.model.DescribeJobsRequestFilters.wrap(buildAwsValue())
}
object DescribeJobsRequestFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.DescribeJobsRequestFilters =
      zio.aws.mgn.model.DescribeJobsRequestFilters(
        fromDate.map(value => value),
        jobIDs.map(value => value),
        toDate.map(value => value)
      )
    def fromDate: Option[ISO8601DatetimeString]
    def jobIDs: Option[List[JobID]]
    def toDate: Option[ISO8601DatetimeString]
    def getFromDate: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("fromDate", fromDate)
    def getJobIDs: ZIO[Any, AwsError, List[JobID]] =
      AwsError.unwrapOptionField("jobIDs", jobIDs)
    def getToDate: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("toDate", toDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
  ) extends zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly {
    override val fromDate: Option[ISO8601DatetimeString] = scala
      .Option(impl.fromDate())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val jobIDs: Option[List[JobID]] = scala
      .Option(impl.jobIDs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mgn.model.primitives.JobID(item)
        }.toList
      )
    override val toDate: Option[ISO8601DatetimeString] = scala
      .Option(impl.toDate())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.DescribeJobsRequestFilters
  ): zio.aws.mgn.model.DescribeJobsRequestFilters.ReadOnly = new Wrapper(impl)
}
