package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.{
  SubnetID,
  SecurityGroupID,
  PositiveInteger,
  TagValue,
  EC2InstanceType,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateReplicationConfigurationTemplateRequest(
    associateDefaultSecurityGroup: Boolean,
    bandwidthThrottling: PositiveInteger,
    createPublicIP: Boolean,
    dataPlaneRouting: zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting,
    defaultLargeStagingDiskType: zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType,
    ebsEncryption: zio.aws.mgn.model.ReplicationConfigurationEbsEncryption,
    ebsEncryptionKeyArn: Option[ARN] = None,
    replicationServerInstanceType: EC2InstanceType,
    replicationServersSecurityGroupsIDs: Iterable[SecurityGroupID],
    stagingAreaSubnetId: SubnetID,
    stagingAreaTags: Map[TagKey, TagValue],
    tags: Option[Map[TagKey, TagValue]] = None,
    useDedicatedReplicationServer: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest = {
    import CreateReplicationConfigurationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest
      .builder()
      .associateDefaultSecurityGroup(
        associateDefaultSecurityGroup: java.lang.Boolean
      )
      .bandwidthThrottling(
        PositiveInteger.unwrap(bandwidthThrottling): java.lang.Long
      )
      .createPublicIP(createPublicIP: java.lang.Boolean)
      .dataPlaneRouting(dataPlaneRouting.unwrap)
      .defaultLargeStagingDiskType(defaultLargeStagingDiskType.unwrap)
      .ebsEncryption(ebsEncryption.unwrap)
      .optionallyWith(
        ebsEncryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.ebsEncryptionKeyArn)
      .replicationServerInstanceType(
        EC2InstanceType.unwrap(replicationServerInstanceType): java.lang.String
      )
      .replicationServersSecurityGroupsIDs(
        replicationServersSecurityGroupsIDs.map { item =>
          SecurityGroupID.unwrap(item): java.lang.String
        }.asJavaCollection
      )
      .stagingAreaSubnetId(
        SubnetID.unwrap(stagingAreaSubnetId): java.lang.String
      )
      .stagingAreaTags(
        stagingAreaTags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .useDedicatedReplicationServer(
        useDedicatedReplicationServer: java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest.ReadOnly =
    zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest
      .wrap(buildAwsValue())
}
object CreateReplicationConfigurationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest =
      zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest(
        associateDefaultSecurityGroup,
        bandwidthThrottling,
        createPublicIP,
        dataPlaneRouting,
        defaultLargeStagingDiskType,
        ebsEncryption,
        ebsEncryptionKeyArn.map(value => value),
        replicationServerInstanceType,
        replicationServersSecurityGroupsIDs,
        stagingAreaSubnetId,
        stagingAreaTags,
        tags.map(value => value),
        useDedicatedReplicationServer
      )
    def associateDefaultSecurityGroup: Boolean
    def bandwidthThrottling: PositiveInteger
    def createPublicIP: Boolean
    def dataPlaneRouting
        : zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting
    def defaultLargeStagingDiskType
        : zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    def ebsEncryption: zio.aws.mgn.model.ReplicationConfigurationEbsEncryption
    def ebsEncryptionKeyArn: Option[ARN]
    def replicationServerInstanceType: EC2InstanceType
    def replicationServersSecurityGroupsIDs: List[SecurityGroupID]
    def stagingAreaSubnetId: SubnetID
    def stagingAreaTags: Map[TagKey, TagValue]
    def tags: Option[Map[TagKey, TagValue]]
    def useDedicatedReplicationServer: Boolean
    def getAssociateDefaultSecurityGroup: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(associateDefaultSecurityGroup)
    def getBandwidthThrottling: ZIO[Any, Nothing, PositiveInteger] =
      ZIO.succeed(bandwidthThrottling)
    def getCreatePublicIP: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(createPublicIP)
    def getDataPlaneRouting: ZIO[
      Any,
      Nothing,
      zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting
    ] = ZIO.succeed(dataPlaneRouting)
    def getDefaultLargeStagingDiskType: ZIO[
      Any,
      Nothing,
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
    ] = ZIO.succeed(defaultLargeStagingDiskType)
    def getEbsEncryption: ZIO[
      Any,
      Nothing,
      zio.aws.mgn.model.ReplicationConfigurationEbsEncryption
    ] = ZIO.succeed(ebsEncryption)
    def getEbsEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("ebsEncryptionKeyArn", ebsEncryptionKeyArn)
    def getReplicationServerInstanceType: ZIO[Any, Nothing, EC2InstanceType] =
      ZIO.succeed(replicationServerInstanceType)
    def getReplicationServersSecurityGroupsIDs
        : ZIO[Any, Nothing, List[SecurityGroupID]] =
      ZIO.succeed(replicationServersSecurityGroupsIDs)
    def getStagingAreaSubnetId: ZIO[Any, Nothing, SubnetID] =
      ZIO.succeed(stagingAreaSubnetId)
    def getStagingAreaTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] =
      ZIO.succeed(stagingAreaTags)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUseDedicatedReplicationServer: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(useDedicatedReplicationServer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest
  ) extends zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest.ReadOnly {
    override val associateDefaultSecurityGroup: Boolean =
      impl.associateDefaultSecurityGroup(): Boolean
    override val bandwidthThrottling: PositiveInteger =
      zio.aws.mgn.model.primitives.PositiveInteger(impl.bandwidthThrottling())
    override val createPublicIP: Boolean = impl.createPublicIP(): Boolean
    override val dataPlaneRouting
        : zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting =
      zio.aws.mgn.model.ReplicationConfigurationDataPlaneRouting
        .wrap(impl.dataPlaneRouting())
    override val defaultLargeStagingDiskType
        : zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType =
      zio.aws.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType
        .wrap(impl.defaultLargeStagingDiskType())
    override val ebsEncryption
        : zio.aws.mgn.model.ReplicationConfigurationEbsEncryption =
      zio.aws.mgn.model.ReplicationConfigurationEbsEncryption
        .wrap(impl.ebsEncryption())
    override val ebsEncryptionKeyArn: Option[ARN] = scala
      .Option(impl.ebsEncryptionKeyArn())
      .map(value => zio.aws.mgn.model.primitives.ARN(value))
    override val replicationServerInstanceType: EC2InstanceType =
      zio.aws.mgn.model.primitives
        .EC2InstanceType(impl.replicationServerInstanceType())
    override val replicationServersSecurityGroupsIDs: List[SecurityGroupID] =
      impl
        .replicationServersSecurityGroupsIDs()
        .asScala
        .map { item =>
          zio.aws.mgn.model.primitives.SecurityGroupID(item)
        }
        .toList
    override val stagingAreaSubnetId: SubnetID =
      zio.aws.mgn.model.primitives.SubnetID(impl.stagingAreaSubnetId())
    override val stagingAreaTags: Map[TagKey, TagValue] = impl
      .stagingAreaTags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.mgn.model.primitives.TagKey(key) -> zio.aws.mgn.model.primitives
          .TagValue(value)
      })
      .toMap
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mgn.model.primitives
              .TagKey(key) -> zio.aws.mgn.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val useDedicatedReplicationServer: Boolean =
      impl.useDedicatedReplicationServer(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest
  ): zio.aws.mgn.model.CreateReplicationConfigurationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
