package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class LifeCycle(
    addedToServiceDateTime: Option[ISO8601DatetimeString] = None,
    elapsedReplicationDuration: Option[ISO8601DatetimeString] = None,
    firstByteDateTime: Option[ISO8601DatetimeString] = None,
    lastCutover: Option[zio.aws.mgn.model.LifeCycleLastCutover] = None,
    lastSeenByServiceDateTime: Option[ISO8601DatetimeString] = None,
    lastTest: Option[zio.aws.mgn.model.LifeCycleLastTest] = None,
    state: Option[zio.aws.mgn.model.LifeCycleState] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.LifeCycle = {
    import LifeCycle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.LifeCycle
      .builder()
      .optionallyWith(
        addedToServiceDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.addedToServiceDateTime)
      .optionallyWith(
        elapsedReplicationDuration.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.elapsedReplicationDuration)
      .optionallyWith(
        firstByteDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.firstByteDateTime)
      .optionallyWith(lastCutover.map(value => value.buildAwsValue()))(
        _.lastCutover
      )
      .optionallyWith(
        lastSeenByServiceDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.lastSeenByServiceDateTime)
      .optionallyWith(lastTest.map(value => value.buildAwsValue()))(_.lastTest)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.LifeCycle.ReadOnly =
    zio.aws.mgn.model.LifeCycle.wrap(buildAwsValue())
}
object LifeCycle {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.LifeCycle] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.LifeCycle = zio.aws.mgn.model.LifeCycle(
      addedToServiceDateTime.map(value => value),
      elapsedReplicationDuration.map(value => value),
      firstByteDateTime.map(value => value),
      lastCutover.map(value => value.asEditable),
      lastSeenByServiceDateTime.map(value => value),
      lastTest.map(value => value.asEditable),
      state.map(value => value)
    )
    def addedToServiceDateTime: Option[ISO8601DatetimeString]
    def elapsedReplicationDuration: Option[ISO8601DatetimeString]
    def firstByteDateTime: Option[ISO8601DatetimeString]
    def lastCutover: Option[zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly]
    def lastSeenByServiceDateTime: Option[ISO8601DatetimeString]
    def lastTest: Option[zio.aws.mgn.model.LifeCycleLastTest.ReadOnly]
    def state: Option[zio.aws.mgn.model.LifeCycleState]
    def getAddedToServiceDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField(
        "addedToServiceDateTime",
        addedToServiceDateTime
      )
    def getElapsedReplicationDuration
        : ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField(
        "elapsedReplicationDuration",
        elapsedReplicationDuration
      )
    def getFirstByteDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("firstByteDateTime", firstByteDateTime)
    def getLastCutover
        : ZIO[Any, AwsError, zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly] =
      AwsError.unwrapOptionField("lastCutover", lastCutover)
    def getLastSeenByServiceDateTime
        : ZIO[Any, AwsError, ISO8601DatetimeString] = AwsError
      .unwrapOptionField("lastSeenByServiceDateTime", lastSeenByServiceDateTime)
    def getLastTest
        : ZIO[Any, AwsError, zio.aws.mgn.model.LifeCycleLastTest.ReadOnly] =
      AwsError.unwrapOptionField("lastTest", lastTest)
    def getState: ZIO[Any, AwsError, zio.aws.mgn.model.LifeCycleState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycle
  ) extends zio.aws.mgn.model.LifeCycle.ReadOnly {
    override val addedToServiceDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.addedToServiceDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val elapsedReplicationDuration: Option[ISO8601DatetimeString] =
      scala
        .Option(impl.elapsedReplicationDuration())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val firstByteDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.firstByteDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val lastCutover
        : Option[zio.aws.mgn.model.LifeCycleLastCutover.ReadOnly] = scala
      .Option(impl.lastCutover())
      .map(value => zio.aws.mgn.model.LifeCycleLastCutover.wrap(value))
    override val lastSeenByServiceDateTime: Option[ISO8601DatetimeString] =
      scala
        .Option(impl.lastSeenByServiceDateTime())
        .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
    override val lastTest
        : Option[zio.aws.mgn.model.LifeCycleLastTest.ReadOnly] = scala
      .Option(impl.lastTest())
      .map(value => zio.aws.mgn.model.LifeCycleLastTest.wrap(value))
    override val state: Option[zio.aws.mgn.model.LifeCycleState] = scala
      .Option(impl.state())
      .map(value => zio.aws.mgn.model.LifeCycleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.LifeCycle
  ): zio.aws.mgn.model.LifeCycle.ReadOnly = new Wrapper(impl)
}
