package zio.aws.mgn.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mgn.model.primitives.ISO8601DatetimeString
import scala.jdk.CollectionConverters._
final case class JobLog(
    event: Option[zio.aws.mgn.model.JobLogEvent] = None,
    eventData: Option[zio.aws.mgn.model.JobLogEventData] = None,
    logDateTime: Option[ISO8601DatetimeString] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.mgn.model.JobLog = {
    import JobLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mgn.model.JobLog
      .builder()
      .optionallyWith(event.map(value => value.unwrap))(_.event)
      .optionallyWith(eventData.map(value => value.buildAwsValue()))(
        _.eventData
      )
      .optionallyWith(
        logDateTime.map(value =>
          ISO8601DatetimeString.unwrap(value): java.lang.String
        )
      )(_.logDateTime)
      .build()
  }
  def asReadOnly: zio.aws.mgn.model.JobLog.ReadOnly =
    zio.aws.mgn.model.JobLog.wrap(buildAwsValue())
}
object JobLog {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mgn.model.JobLog] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mgn.model.JobLog = zio.aws.mgn.model.JobLog(
      event.map(value => value),
      eventData.map(value => value.asEditable),
      logDateTime.map(value => value)
    )
    def event: Option[zio.aws.mgn.model.JobLogEvent]
    def eventData: Option[zio.aws.mgn.model.JobLogEventData.ReadOnly]
    def logDateTime: Option[ISO8601DatetimeString]
    def getEvent: ZIO[Any, AwsError, zio.aws.mgn.model.JobLogEvent] =
      AwsError.unwrapOptionField("event", event)
    def getEventData
        : ZIO[Any, AwsError, zio.aws.mgn.model.JobLogEventData.ReadOnly] =
      AwsError.unwrapOptionField("eventData", eventData)
    def getLogDateTime: ZIO[Any, AwsError, ISO8601DatetimeString] =
      AwsError.unwrapOptionField("logDateTime", logDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mgn.model.JobLog
  ) extends zio.aws.mgn.model.JobLog.ReadOnly {
    override val event: Option[zio.aws.mgn.model.JobLogEvent] = scala
      .Option(impl.event())
      .map(value => zio.aws.mgn.model.JobLogEvent.wrap(value))
    override val eventData: Option[zio.aws.mgn.model.JobLogEventData.ReadOnly] =
      scala
        .Option(impl.eventData())
        .map(value => zio.aws.mgn.model.JobLogEventData.wrap(value))
    override val logDateTime: Option[ISO8601DatetimeString] = scala
      .Option(impl.logDateTime())
      .map(value => zio.aws.mgn.model.primitives.ISO8601DatetimeString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mgn.model.JobLog
  ): zio.aws.mgn.model.JobLog.ReadOnly = new Wrapper(impl)
}
