package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait FirstBoot {
  def unwrap: software.amazon.awssdk.services.mgn.model.FirstBoot
}
object FirstBoot {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.FirstBoot
  ): zio.aws.mgn.model.FirstBoot = value match {
    case software.amazon.awssdk.services.mgn.model.FirstBoot.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.FirstBoot.WAITING =>
      val r = WAITING
      r
    case software.amazon.awssdk.services.mgn.model.FirstBoot.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.mgn.model.FirstBoot.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.mgn.model.FirstBoot.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.FirstBoot {
    override def unwrap: software.amazon.awssdk.services.mgn.model.FirstBoot =
      software.amazon.awssdk.services.mgn.model.FirstBoot.UNKNOWN_TO_SDK_VERSION
  }
  case object WAITING extends zio.aws.mgn.model.FirstBoot {
    override def unwrap: software.amazon.awssdk.services.mgn.model.FirstBoot =
      software.amazon.awssdk.services.mgn.model.FirstBoot.WAITING
  }
  case object SUCCEEDED extends zio.aws.mgn.model.FirstBoot {
    override def unwrap: software.amazon.awssdk.services.mgn.model.FirstBoot =
      software.amazon.awssdk.services.mgn.model.FirstBoot.SUCCEEDED
  }
  case object UNKNOWN extends zio.aws.mgn.model.FirstBoot {
    override def unwrap: software.amazon.awssdk.services.mgn.model.FirstBoot =
      software.amazon.awssdk.services.mgn.model.FirstBoot.UNKNOWN
  }
  case object STOPPED extends zio.aws.mgn.model.FirstBoot {
    override def unwrap: software.amazon.awssdk.services.mgn.model.FirstBoot =
      software.amazon.awssdk.services.mgn.model.FirstBoot.STOPPED
  }
}
