package zio.aws.mgn.model
import scala.jdk.CollectionConverters._
sealed trait LaunchDisposition {
  def unwrap: software.amazon.awssdk.services.mgn.model.LaunchDisposition
}
object LaunchDisposition {
  def wrap(
      value: software.amazon.awssdk.services.mgn.model.LaunchDisposition
  ): zio.aws.mgn.model.LaunchDisposition = value match {
    case software.amazon.awssdk.services.mgn.model.LaunchDisposition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mgn.model.LaunchDisposition.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.mgn.model.LaunchDisposition.STARTED =>
      val r = STARTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mgn.model.LaunchDisposition {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchDisposition =
      software.amazon.awssdk.services.mgn.model.LaunchDisposition.UNKNOWN_TO_SDK_VERSION
  }
  case object STOPPED extends zio.aws.mgn.model.LaunchDisposition {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchDisposition =
      software.amazon.awssdk.services.mgn.model.LaunchDisposition.STOPPED
  }
  case object STARTED extends zio.aws.mgn.model.LaunchDisposition {
    override def unwrap
        : software.amazon.awssdk.services.mgn.model.LaunchDisposition =
      software.amazon.awssdk.services.mgn.model.LaunchDisposition.STARTED
  }
}
