package zio.aws.mgn
import zio.aws.mgn.model.GetLaunchConfigurationResponse.ReadOnly
import software.amazon.awssdk.services.mgn.MgnAsyncClient
import zio.aws.mgn.model.{
  DescribeReplicationConfigurationTemplatesRequest,
  CreateReplicationConfigurationTemplateRequest,
  DeleteVcenterClientRequest,
  DisconnectFromServiceRequest,
  UpdateSourceServerReplicationTypeRequest,
  FinalizeCutoverRequest,
  GetReplicationConfigurationRequest,
  UpdateLaunchConfigurationRequest,
  DeleteReplicationConfigurationTemplateRequest,
  StartReplicationRequest,
  ListTagsForResourceRequest,
  RetryDataReplicationRequest,
  TerminateTargetInstancesRequest,
  DescribeJobsRequest,
  MarkAsArchivedRequest,
  DeleteJobRequest,
  DescribeSourceServersRequest,
  GetLaunchConfigurationRequest,
  UpdateReplicationConfigurationRequest,
  DescribeJobLogItemsRequest,
  UntagResourceRequest,
  DeleteSourceServerRequest,
  StartCutoverRequest,
  DescribeVcenterClientsRequest,
  ChangeServerLifeCycleStateRequest,
  StartTestRequest,
  UpdateReplicationConfigurationTemplateRequest,
  TagResourceRequest,
  InitializeServiceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object MgnMock extends Mock[Mgn] {
  object DeleteSourceServer
      extends Effect[
        DeleteSourceServerRequest,
        AwsError,
        zio.aws.mgn.model.DeleteSourceServerResponse.ReadOnly
      ]
  object GetLaunchConfiguration
      extends Effect[GetLaunchConfigurationRequest, AwsError, ReadOnly]
  object UpdateReplicationConfigurationTemplate
      extends Effect[
        UpdateReplicationConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.ReadOnly
      ]
  object TerminateTargetInstances
      extends Effect[
        TerminateTargetInstancesRequest,
        AwsError,
        zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly
      ]
  object MarkAsArchived
      extends Effect[
        MarkAsArchivedRequest,
        AwsError,
        zio.aws.mgn.model.MarkAsArchivedResponse.ReadOnly
      ]
  object DescribeVcenterClients
      extends Stream[
        DescribeVcenterClientsRequest,
        AwsError,
        zio.aws.mgn.model.VcenterClient.ReadOnly
      ]
  object DescribeVcenterClientsPaginated
      extends Effect[
        DescribeVcenterClientsRequest,
        AwsError,
        zio.aws.mgn.model.DescribeVcenterClientsResponse.ReadOnly
      ]
  object DescribeReplicationConfigurationTemplates
      extends Stream[
        DescribeReplicationConfigurationTemplatesRequest,
        AwsError,
        zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
      ]
  object DescribeReplicationConfigurationTemplatesPaginated
      extends Effect[
        DescribeReplicationConfigurationTemplatesRequest,
        AwsError,
        zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly
      ]
  object StartCutover
      extends Effect[
        StartCutoverRequest,
        AwsError,
        zio.aws.mgn.model.StartCutoverResponse.ReadOnly
      ]
  object InitializeService
      extends Effect[
        InitializeServiceRequest,
        AwsError,
        zio.aws.mgn.model.InitializeServiceResponse.ReadOnly
      ]
  object GetReplicationConfiguration
      extends Effect[
        GetReplicationConfigurationRequest,
        AwsError,
        zio.aws.mgn.model.GetReplicationConfigurationResponse.ReadOnly
      ]
  object StartReplication
      extends Effect[
        StartReplicationRequest,
        AwsError,
        zio.aws.mgn.model.StartReplicationResponse.ReadOnly
      ]
  object DescribeJobLogItems
      extends Stream[
        DescribeJobLogItemsRequest,
        AwsError,
        zio.aws.mgn.model.JobLog.ReadOnly
      ]
  object DescribeJobLogItemsPaginated
      extends Effect[
        DescribeJobLogItemsRequest,
        AwsError,
        zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly
      ]
  object UpdateSourceServerReplicationType
      extends Effect[
        UpdateSourceServerReplicationTypeRequest,
        AwsError,
        zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.ReadOnly
      ]
  object DeleteVcenterClient
      extends Effect[DeleteVcenterClientRequest, AwsError, Unit]
  object DisconnectFromService
      extends Effect[
        DisconnectFromServiceRequest,
        AwsError,
        zio.aws.mgn.model.DisconnectFromServiceResponse.ReadOnly
      ]
  object DescribeJobs
      extends Stream[
        DescribeJobsRequest,
        AwsError,
        zio.aws.mgn.model.Job.ReadOnly
      ]
  object DescribeJobsPaginated
      extends Effect[
        DescribeJobsRequest,
        AwsError,
        zio.aws.mgn.model.DescribeJobsResponse.ReadOnly
      ]
  object CreateReplicationConfigurationTemplate
      extends Effect[
        CreateReplicationConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.ReadOnly
      ]
  object UpdateLaunchConfiguration
      extends Effect[
        UpdateLaunchConfigurationRequest,
        AwsError,
        zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly
      ]
  object UpdateReplicationConfiguration
      extends Effect[
        UpdateReplicationConfigurationRequest,
        AwsError,
        zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly
      ]
  object DescribeSourceServers
      extends Stream[
        DescribeSourceServersRequest,
        AwsError,
        zio.aws.mgn.model.SourceServer.ReadOnly
      ]
  object DescribeSourceServersPaginated
      extends Effect[
        DescribeSourceServersRequest,
        AwsError,
        zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DeleteReplicationConfigurationTemplate
      extends Effect[
        DeleteReplicationConfigurationTemplateRequest,
        AwsError,
        zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.mgn.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object FinalizeCutover
      extends Effect[
        FinalizeCutoverRequest,
        AwsError,
        zio.aws.mgn.model.FinalizeCutoverResponse.ReadOnly
      ]
  object RetryDataReplication
      extends Effect[
        RetryDataReplicationRequest,
        AwsError,
        zio.aws.mgn.model.RetryDataReplicationResponse.ReadOnly
      ]
  object ChangeServerLifeCycleState
      extends Effect[
        ChangeServerLifeCycleStateRequest,
        AwsError,
        zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.ReadOnly
      ]
  object StartTest
      extends Effect[
        StartTestRequest,
        AwsError,
        zio.aws.mgn.model.StartTestResponse.ReadOnly
      ]
  object DeleteJob
      extends Effect[
        DeleteJobRequest,
        AwsError,
        zio.aws.mgn.model.DeleteJobResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Mgn] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Mgn {
          val api: MgnAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Mgn = this
          def deleteSourceServer(request: DeleteSourceServerRequest): IO[
            AwsError,
            zio.aws.mgn.model.DeleteSourceServerResponse.ReadOnly
          ] = proxy(DeleteSourceServer, request)
          def getLaunchConfiguration(
              request: GetLaunchConfigurationRequest
          ): IO[AwsError, ReadOnly] = proxy(GetLaunchConfiguration, request)
          def updateReplicationConfigurationTemplate(
              request: UpdateReplicationConfigurationTemplateRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.UpdateReplicationConfigurationTemplateResponse.ReadOnly
          ] = proxy(UpdateReplicationConfigurationTemplate, request)
          def terminateTargetInstances(
              request: TerminateTargetInstancesRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.TerminateTargetInstancesResponse.ReadOnly
          ] = proxy(TerminateTargetInstances, request)
          def markAsArchived(
              request: MarkAsArchivedRequest
          ): IO[AwsError, zio.aws.mgn.model.MarkAsArchivedResponse.ReadOnly] =
            proxy(MarkAsArchived, request)
          def describeVcenterClients(
              request: DescribeVcenterClientsRequest
          ): ZStream[Any, AwsError, zio.aws.mgn.model.VcenterClient.ReadOnly] =
            rts.unsafeRun(proxy(DescribeVcenterClients, request))
          def describeVcenterClientsPaginated(
              request: DescribeVcenterClientsRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.DescribeVcenterClientsResponse.ReadOnly
          ] = proxy(DescribeVcenterClientsPaginated, request)
          def describeReplicationConfigurationTemplates(
              request: DescribeReplicationConfigurationTemplatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.mgn.model.ReplicationConfigurationTemplate.ReadOnly
          ] = rts.unsafeRun(
            proxy(DescribeReplicationConfigurationTemplates, request)
          )
          def describeReplicationConfigurationTemplatesPaginated(
              request: DescribeReplicationConfigurationTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.DescribeReplicationConfigurationTemplatesResponse.ReadOnly
          ] = proxy(DescribeReplicationConfigurationTemplatesPaginated, request)
          def startCutover(
              request: StartCutoverRequest
          ): IO[AwsError, zio.aws.mgn.model.StartCutoverResponse.ReadOnly] =
            proxy(StartCutover, request)
          def initializeService(request: InitializeServiceRequest): IO[
            AwsError,
            zio.aws.mgn.model.InitializeServiceResponse.ReadOnly
          ] = proxy(InitializeService, request)
          def getReplicationConfiguration(
              request: GetReplicationConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.GetReplicationConfigurationResponse.ReadOnly
          ] = proxy(GetReplicationConfiguration, request)
          def startReplication(
              request: StartReplicationRequest
          ): IO[AwsError, zio.aws.mgn.model.StartReplicationResponse.ReadOnly] =
            proxy(StartReplication, request)
          def describeJobLogItems(
              request: DescribeJobLogItemsRequest
          ): ZStream[Any, AwsError, zio.aws.mgn.model.JobLog.ReadOnly] =
            rts.unsafeRun(proxy(DescribeJobLogItems, request))
          def describeJobLogItemsPaginated(
              request: DescribeJobLogItemsRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.DescribeJobLogItemsResponse.ReadOnly
          ] = proxy(DescribeJobLogItemsPaginated, request)
          def updateSourceServerReplicationType(
              request: UpdateSourceServerReplicationTypeRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.UpdateSourceServerReplicationTypeResponse.ReadOnly
          ] = proxy(UpdateSourceServerReplicationType, request)
          def deleteVcenterClient(
              request: DeleteVcenterClientRequest
          ): IO[AwsError, Unit] = proxy(DeleteVcenterClient, request)
          def disconnectFromService(request: DisconnectFromServiceRequest): IO[
            AwsError,
            zio.aws.mgn.model.DisconnectFromServiceResponse.ReadOnly
          ] = proxy(DisconnectFromService, request)
          def describeJobs(
              request: DescribeJobsRequest
          ): ZStream[Any, AwsError, zio.aws.mgn.model.Job.ReadOnly] =
            rts.unsafeRun(proxy(DescribeJobs, request))
          def describeJobsPaginated(
              request: DescribeJobsRequest
          ): IO[AwsError, zio.aws.mgn.model.DescribeJobsResponse.ReadOnly] =
            proxy(DescribeJobsPaginated, request)
          def createReplicationConfigurationTemplate(
              request: CreateReplicationConfigurationTemplateRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.CreateReplicationConfigurationTemplateResponse.ReadOnly
          ] = proxy(CreateReplicationConfigurationTemplate, request)
          def updateLaunchConfiguration(
              request: UpdateLaunchConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.UpdateLaunchConfigurationResponse.ReadOnly
          ] = proxy(UpdateLaunchConfiguration, request)
          def updateReplicationConfiguration(
              request: UpdateReplicationConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.UpdateReplicationConfigurationResponse.ReadOnly
          ] = proxy(UpdateReplicationConfiguration, request)
          def describeSourceServers(
              request: DescribeSourceServersRequest
          ): ZStream[Any, AwsError, zio.aws.mgn.model.SourceServer.ReadOnly] =
            rts.unsafeRun(proxy(DescribeSourceServers, request))
          def describeSourceServersPaginated(
              request: DescribeSourceServersRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.DescribeSourceServersResponse.ReadOnly
          ] = proxy(DescribeSourceServersPaginated, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def deleteReplicationConfigurationTemplate(
              request: DeleteReplicationConfigurationTemplateRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.DeleteReplicationConfigurationTemplateResponse.ReadOnly
          ] = proxy(DeleteReplicationConfigurationTemplate, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.mgn.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def finalizeCutover(
              request: FinalizeCutoverRequest
          ): IO[AwsError, zio.aws.mgn.model.FinalizeCutoverResponse.ReadOnly] =
            proxy(FinalizeCutover, request)
          def retryDataReplication(request: RetryDataReplicationRequest): IO[
            AwsError,
            zio.aws.mgn.model.RetryDataReplicationResponse.ReadOnly
          ] = proxy(RetryDataReplication, request)
          def changeServerLifeCycleState(
              request: ChangeServerLifeCycleStateRequest
          ): IO[
            AwsError,
            zio.aws.mgn.model.ChangeServerLifeCycleStateResponse.ReadOnly
          ] = proxy(ChangeServerLifeCycleState, request)
          def startTest(
              request: StartTestRequest
          ): IO[AwsError, zio.aws.mgn.model.StartTestResponse.ReadOnly] =
            proxy(StartTest, request)
          def deleteJob(
              request: DeleteJobRequest
          ): IO[AwsError, zio.aws.mgn.model.DeleteJobResponse.ReadOnly] =
            proxy(DeleteJob, request)
        }
      }
    }
    .toLayer
}
