package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateParameterGroupResponse(
    parameterGroup: Optional[zio.aws.memorydb.model.ParameterGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse = {
    import UpdateParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse
      .builder()
      .optionallyWith(parameterGroup.map(value => value.buildAwsValue()))(
        _.parameterGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly =
    zio.aws.memorydb.model.UpdateParameterGroupResponse.wrap(buildAwsValue())
}
object UpdateParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UpdateParameterGroupResponse =
      zio.aws.memorydb.model.UpdateParameterGroupResponse(
        parameterGroup.map(value => value.asEditable)
      )
    def parameterGroup: Optional[zio.aws.memorydb.model.ParameterGroup.ReadOnly]
    def getParameterGroup
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("parameterGroup", parameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse
  ) extends zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly {
    override val parameterGroup
        : Optional[zio.aws.memorydb.model.ParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterGroup())
        .map(value => zio.aws.memorydb.model.ParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse
  ): zio.aws.memorydb.model.UpdateParameterGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
