package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeReservedNodesOfferingsResponse(
    nextToken: Optional[String] = Optional.Absent,
    reservedNodesOfferings: Optional[
      Iterable[zio.aws.memorydb.model.ReservedNodesOffering]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse = {
    import DescribeReservedNodesOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reservedNodesOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedNodesOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeReservedNodesOfferingsResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeReservedNodesOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedNodesOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.memorydb.model.DescribeReservedNodesOfferingsResponse =
      zio.aws.memorydb.model.DescribeReservedNodesOfferingsResponse(
        nextToken.map(value => value),
        reservedNodesOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def reservedNodesOfferings
        : Optional[List[zio.aws.memorydb.model.ReservedNodesOffering.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedNodesOfferings: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.ReservedNodesOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedNodesOfferings",
      reservedNodesOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse
  ) extends zio.aws.memorydb.model.DescribeReservedNodesOfferingsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val reservedNodesOfferings: Optional[
      List[zio.aws.memorydb.model.ReservedNodesOffering.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedNodesOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.memorydb.model.ReservedNodesOffering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse
  ): zio.aws.memorydb.model.DescribeReservedNodesOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
