package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEngineVersionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    engineVersions: Optional[
      Iterable[zio.aws.memorydb.model.EngineVersionInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse = {
    import DescribeEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        engineVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeEngineVersionsResponse.wrap(buildAwsValue())
}
object DescribeEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeEngineVersionsResponse =
      zio.aws.memorydb.model.DescribeEngineVersionsResponse(
        nextToken.map(value => value),
        engineVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def engineVersions
        : Optional[List[zio.aws.memorydb.model.EngineVersionInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getEngineVersions: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.EngineVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("engineVersions", engineVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
  ) extends zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val engineVersions
        : Optional[List[zio.aws.memorydb.model.EngineVersionInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.EngineVersionInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse
  ): zio.aws.memorydb.model.DescribeEngineVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
