package zio.aws.memorydb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.{IntegerOptional, TStamp}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEventsRequest(
    sourceName: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.memorydb.model.SourceType] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    endTime: Optional[TStamp] = Optional.Absent,
    duration: Optional[IntegerOptional] = Optional.Absent,
    maxResults: Optional[IntegerOptional] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
      .builder()
      .optionallyWith(sourceName.map(value => value: java.lang.String))(
        _.sourceName
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeEventsRequest.ReadOnly =
    zio.aws.memorydb.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeEventsRequest =
      zio.aws.memorydb.model.DescribeEventsRequest(
        sourceName.map(value => value),
        sourceType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        duration.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sourceName: Optional[String]
    def sourceType: Optional[zio.aws.memorydb.model.SourceType]
    def startTime: Optional[TStamp]
    def endTime: Optional[TStamp]
    def duration: Optional[IntegerOptional]
    def maxResults: Optional[IntegerOptional]
    def nextToken: Optional[String]
    def getSourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceType: ZIO[Any, AwsError, zio.aws.memorydb.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("duration", duration)
    def getMaxResults: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
  ) extends zio.aws.memorydb.model.DescribeEventsRequest.ReadOnly {
    override val sourceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceName())
      .map(value => value: String)
    override val sourceType: Optional[zio.aws.memorydb.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.memorydb.model.SourceType.wrap(value))
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
    override val endTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.memorydb.model.primitives.TStamp(value))
    override val duration: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: IntegerOptional)
    override val maxResults: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: IntegerOptional)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest
  ): zio.aws.memorydb.model.DescribeEventsRequest.ReadOnly = new Wrapper(impl)
}
