package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeReservedNodesResponse(
    nextToken: Optional[String] = Optional.Absent,
    reservedNodes: Optional[Iterable[zio.aws.memorydb.model.ReservedNode]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse = {
    import DescribeReservedNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reservedNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedNodes)
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.DescribeReservedNodesResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeReservedNodesResponse.wrap(buildAwsValue())
}
object DescribeReservedNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeReservedNodesResponse =
      zio.aws.memorydb.model.DescribeReservedNodesResponse(
        nextToken.map(value => value),
        reservedNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def reservedNodes
        : Optional[List[zio.aws.memorydb.model.ReservedNode.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedNodes: ZIO[Any, AwsError, List[
      zio.aws.memorydb.model.ReservedNode.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedNodes", reservedNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse
  ) extends zio.aws.memorydb.model.DescribeReservedNodesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val reservedNodes
        : Optional[List[zio.aws.memorydb.model.ReservedNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.ReservedNode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse
  ): zio.aws.memorydb.model.DescribeReservedNodesResponse.ReadOnly =
    new Wrapper(impl)
}
