package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PurchaseReservedNodesOfferingResponse(
    reservedNode: Optional[zio.aws.memorydb.model.ReservedNode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse = {
    import PurchaseReservedNodesOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse
      .builder()
      .optionallyWith(reservedNode.map(value => value.buildAwsValue()))(
        _.reservedNode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.memorydb.model.PurchaseReservedNodesOfferingResponse.ReadOnly =
    zio.aws.memorydb.model.PurchaseReservedNodesOfferingResponse
      .wrap(buildAwsValue())
}
object PurchaseReservedNodesOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.memorydb.model.PurchaseReservedNodesOfferingResponse =
      zio.aws.memorydb.model.PurchaseReservedNodesOfferingResponse(
        reservedNode.map(value => value.asEditable)
      )
    def reservedNode: Optional[zio.aws.memorydb.model.ReservedNode.ReadOnly]
    def getReservedNode
        : ZIO[Any, AwsError, zio.aws.memorydb.model.ReservedNode.ReadOnly] =
      AwsError.unwrapOptionField("reservedNode", reservedNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse
  ) extends zio.aws.memorydb.model.PurchaseReservedNodesOfferingResponse.ReadOnly {
    override val reservedNode
        : Optional[zio.aws.memorydb.model.ReservedNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedNode())
        .map(value => zio.aws.memorydb.model.ReservedNode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse
  ): zio.aws.memorydb.model.PurchaseReservedNodesOfferingResponse.ReadOnly =
    new Wrapper(impl)
}
