package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteUserResponse(
    user: Optional[zio.aws.memorydb.model.User] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteUserResponse = {
    import DeleteUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteUserResponse.ReadOnly =
    zio.aws.memorydb.model.DeleteUserResponse.wrap(buildAwsValue())
}
object DeleteUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteUserResponse =
      zio.aws.memorydb.model
        .DeleteUserResponse(user.map(value => value.asEditable))
    def user: Optional[zio.aws.memorydb.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.memorydb.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
  ) extends zio.aws.memorydb.model.DeleteUserResponse.ReadOnly {
    override val user: Optional[zio.aws.memorydb.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.memorydb.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteUserResponse
  ): zio.aws.memorydb.model.DeleteUserResponse.ReadOnly = new Wrapper(impl)
}
