package zio.aws.memorydb.model
import scala.jdk.CollectionConverters.*
sealed trait AuthenticationType {
  def unwrap: software.amazon.awssdk.services.memorydb.model.AuthenticationType
}
object AuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.memorydb.model.AuthenticationType
  ): zio.aws.memorydb.model.AuthenticationType = value match {
    case software.amazon.awssdk.services.memorydb.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.memorydb.model.AuthenticationType.PASSWORD =>
      val r = password
      r
    case software.amazon.awssdk.services.memorydb.model.AuthenticationType.NO_PASSWORD =>
      val r = `no-password`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.memorydb.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.AuthenticationType =
      software.amazon.awssdk.services.memorydb.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object password extends zio.aws.memorydb.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.AuthenticationType =
      software.amazon.awssdk.services.memorydb.model.AuthenticationType.PASSWORD
  }
  case object `no-password` extends zio.aws.memorydb.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.memorydb.model.AuthenticationType =
      software.amazon.awssdk.services.memorydb.model.AuthenticationType.NO_PASSWORD
  }
}
