package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeClustersResponse(
    nextToken: Optional[String] = Optional.Absent,
    clusters: Optional[Iterable[zio.aws.memorydb.model.Cluster]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse = {
    import DescribeClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeClustersResponse.wrap(buildAwsValue())
}
object DescribeClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeClustersResponse =
      zio.aws.memorydb.model.DescribeClustersResponse(
        nextToken.map(value => value),
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def clusters: Optional[List[zio.aws.memorydb.model.Cluster.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
  ) extends zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val clusters
        : Optional[List[zio.aws.memorydb.model.Cluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Cluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse
  ): zio.aws.memorydb.model.DescribeClustersResponse.ReadOnly = new Wrapper(
    impl
  )
}
