package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EngineVersionInfo(
    engineVersion: Optional[String] = Optional.Absent,
    enginePatchVersion: Optional[String] = Optional.Absent,
    parameterGroupFamily: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.EngineVersionInfo = {
    import EngineVersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(enginePatchVersion.map(value => value: java.lang.String))(
        _.enginePatchVersion
      )
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.EngineVersionInfo.ReadOnly =
    zio.aws.memorydb.model.EngineVersionInfo.wrap(buildAwsValue())
}
object EngineVersionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.EngineVersionInfo =
      zio.aws.memorydb.model.EngineVersionInfo(
        engineVersion.map(value => value),
        enginePatchVersion.map(value => value),
        parameterGroupFamily.map(value => value)
      )
    def engineVersion: Optional[String]
    def enginePatchVersion: Optional[String]
    def parameterGroupFamily: Optional[String]
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEnginePatchVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("enginePatchVersion", enginePatchVersion)
    def getParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupFamily", parameterGroupFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ) extends zio.aws.memorydb.model.EngineVersionInfo.ReadOnly {
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val enginePatchVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.enginePatchVersion())
      .map(value => value: String)
    override val parameterGroupFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroupFamily())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.EngineVersionInfo
  ): zio.aws.memorydb.model.EngineVersionInfo.ReadOnly = new Wrapper(impl)
}
