package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteParameterGroupRequest(parameterGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest = {
    import DeleteParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteParameterGroupRequest.ReadOnly =
    zio.aws.memorydb.model.DeleteParameterGroupRequest.wrap(buildAwsValue())
}
object DeleteParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteParameterGroupRequest =
      zio.aws.memorydb.model.DeleteParameterGroupRequest(parameterGroupName)
    def parameterGroupName: String
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
  ) extends zio.aws.memorydb.model.DeleteParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest
  ): zio.aws.memorydb.model.DeleteParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
