package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnprocessedCluster(
    clusterName: Optional[String] = Optional.Absent,
    errorType: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.UnprocessedCluster = {
    import UnprocessedCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(errorType.map(value => value: java.lang.String))(
        _.errorType
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.UnprocessedCluster.ReadOnly =
    zio.aws.memorydb.model.UnprocessedCluster.wrap(buildAwsValue())
}
object UnprocessedCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.UnprocessedCluster =
      zio.aws.memorydb.model.UnprocessedCluster(
        clusterName.map(value => value),
        errorType.map(value => value),
        errorMessage.map(value => value)
      )
    def clusterName: Optional[String]
    def errorType: Optional[String]
    def errorMessage: Optional[String]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getErrorType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorType", errorType)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ) extends zio.aws.memorydb.model.UnprocessedCluster.ReadOnly {
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val errorType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorType())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.UnprocessedCluster
  ): zio.aws.memorydb.model.UnprocessedCluster.ReadOnly = new Wrapper(impl)
}
