package zio.aws.memorydb.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.memorydb.model.primitives.IntegerOptional
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Shard(
    name: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    slots: Optional[String] = Optional.Absent,
    nodes: Optional[Iterable[zio.aws.memorydb.model.Node]] = Optional.Absent,
    numberOfNodes: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.memorydb.model.Shard = {
    import Shard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Shard
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Shard.ReadOnly =
    zio.aws.memorydb.model.Shard.wrap(buildAwsValue())
}
object Shard {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Shard] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Shard = zio.aws.memorydb.model.Shard(
      name.map(value => value),
      status.map(value => value),
      slots.map(value => value),
      nodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      numberOfNodes.map(value => value)
    )
    def name: Optional[String]
    def status: Optional[String]
    def slots: Optional[String]
    def nodes: Optional[List[zio.aws.memorydb.model.Node.ReadOnly]]
    def numberOfNodes: Optional[IntegerOptional]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getNodes
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodes", nodes)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Shard
  ) extends zio.aws.memorydb.model.Shard.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val slots: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slots())
      .map(value => value: String)
    override val nodes: Optional[List[zio.aws.memorydb.model.Node.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Node.wrap(item)
          }.toList
        )
    override val numberOfNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNodes())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Shard
  ): zio.aws.memorydb.model.Shard.ReadOnly = new Wrapper(impl)
}
