package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Endpoint(
    address: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.Endpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.Endpoint.ReadOnly =
    zio.aws.memorydb.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.memorydb.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.Endpoint = zio.aws.memorydb.model
      .Endpoint(address.map(value => value), port.map(value => value))
    def address: Optional[String]
    def port: Optional[Integer]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.Endpoint
  ) extends zio.aws.memorydb.model.Endpoint.ReadOnly {
    override val address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.Endpoint
  ): zio.aws.memorydb.model.Endpoint.ReadOnly = new Wrapper(impl)
}
