package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSnapshotResponse(
    snapshot: Optional[zio.aws.memorydb.model.Snapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse = {
    import DeleteSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly =
    zio.aws.memorydb.model.DeleteSnapshotResponse.wrap(buildAwsValue())
}
object DeleteSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DeleteSnapshotResponse =
      zio.aws.memorydb.model
        .DeleteSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.memorydb.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
  ) extends zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly {
    override val snapshot: Optional[zio.aws.memorydb.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.memorydb.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse
  ): zio.aws.memorydb.model.DeleteSnapshotResponse.ReadOnly = new Wrapper(impl)
}
