package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateClusterResponse(
    cluster: Optional[zio.aws.memorydb.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateClusterResponse.ReadOnly =
    zio.aws.memorydb.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateClusterResponse =
      zio.aws.memorydb.model
        .CreateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.memorydb.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.memorydb.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
  ) extends zio.aws.memorydb.model.CreateClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.memorydb.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.memorydb.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateClusterResponse
  ): zio.aws.memorydb.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
