package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSubnetGroupResponse(
    subnetGroup: Optional[zio.aws.memorydb.model.SubnetGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse = {
    import CreateSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
      .builder()
      .optionallyWith(subnetGroup.map(value => value.buildAwsValue()))(
        _.subnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly =
    zio.aws.memorydb.model.CreateSubnetGroupResponse.wrap(buildAwsValue())
}
object CreateSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.CreateSubnetGroupResponse =
      zio.aws.memorydb.model
        .CreateSubnetGroupResponse(subnetGroup.map(value => value.asEditable))
    def subnetGroup: Optional[zio.aws.memorydb.model.SubnetGroup.ReadOnly]
    def getSubnetGroup
        : ZIO[Any, AwsError, zio.aws.memorydb.model.SubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("subnetGroup", subnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
  ) extends zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly {
    override val subnetGroup
        : Optional[zio.aws.memorydb.model.SubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetGroup())
        .map(value => zio.aws.memorydb.model.SubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse
  ): zio.aws.memorydb.model.CreateSubnetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
