package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.memorydb.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ShardConfigurationRequest(
    shardCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest = {
    import ShardConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
      .builder()
      .optionallyWith(shardCount.map(value => value: java.lang.Integer))(
        _.shardCount
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly =
    zio.aws.memorydb.model.ShardConfigurationRequest.wrap(buildAwsValue())
}
object ShardConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ShardConfigurationRequest =
      zio.aws.memorydb.model
        .ShardConfigurationRequest(shardCount.map(value => value))
    def shardCount: Optional[Integer]
    def getShardCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("shardCount", shardCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ) extends zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly {
    override val shardCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.shardCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest
  ): zio.aws.memorydb.model.ShardConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
