package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeUsersResponse(
    users: Optional[Iterable[zio.aws.memorydb.model.User]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse = {
    import DescribeUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeUsersResponse.wrap(buildAwsValue())
}
object DescribeUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeUsersResponse =
      zio.aws.memorydb.model.DescribeUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def users: Optional[List[zio.aws.memorydb.model.User.ReadOnly]]
    def nextToken: Optional[String]
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.User.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
  ) extends zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly {
    override val users: Optional[List[zio.aws.memorydb.model.User.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.User.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse
  ): zio.aws.memorydb.model.DescribeUsersResponse.ReadOnly = new Wrapper(impl)
}
