package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceUpdateRequest(
    serviceUpdateNameToApply: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest = {
    import ServiceUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
      .builder()
      .optionallyWith(
        serviceUpdateNameToApply.map(value => value: java.lang.String)
      )(_.serviceUpdateNameToApply)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly =
    zio.aws.memorydb.model.ServiceUpdateRequest.wrap(buildAwsValue())
}
object ServiceUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.ServiceUpdateRequest =
      zio.aws.memorydb.model
        .ServiceUpdateRequest(serviceUpdateNameToApply.map(value => value))
    def serviceUpdateNameToApply: Optional[String]
    def getServiceUpdateNameToApply: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("serviceUpdateNameToApply", serviceUpdateNameToApply)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ) extends zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly {
    override val serviceUpdateNameToApply: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateNameToApply())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.ServiceUpdateRequest
  ): zio.aws.memorydb.model.ServiceUpdateRequest.ReadOnly = new Wrapper(impl)
}
