package zio.aws.memorydb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotsResponse(
    nextToken: Optional[String] = Optional.Absent,
    snapshots: Optional[Iterable[zio.aws.memorydb.model.Snapshot]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse = {
    import DescribeSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .build()
  }
  def asReadOnly: zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly =
    zio.aws.memorydb.model.DescribeSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.memorydb.model.DescribeSnapshotsResponse =
      zio.aws.memorydb.model.DescribeSnapshotsResponse(
        nextToken.map(value => value),
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def snapshots: Optional[List[zio.aws.memorydb.model.Snapshot.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSnapshots
        : ZIO[Any, AwsError, List[zio.aws.memorydb.model.Snapshot.ReadOnly]] =
      AwsError.unwrapOptionField("snapshots", snapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ) extends zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val snapshots
        : Optional[List[zio.aws.memorydb.model.Snapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.memorydb.model.Snapshot.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse
  ): zio.aws.memorydb.model.DescribeSnapshotsResponse.ReadOnly = new Wrapper(
    impl
  )
}
